;+
; NAME: eis_status_sts3_check.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;       
;
;-------------------------------------------------------------------------------------------------

pro mhc_currents_check, files, lu

    p14 = eis_get_daily_data(files, 'MHC_GND_I_REF', 2, 1, mxp0, mnp0, base_time, end_time)
    p10 = eis_convert_mhc_current_p5vdig(eis_get_daily_data (files, 'MHC_P5V_DI',  1, 3, mx1, mn1), p14)
    avgp1 = moment(p10)
    p11 = eis_convert_mhc_current_p15vana(eis_get_daily_data(files, 'MHC_P15V_AI', 2, 3, mx2, mn2), p14)
    avgp2 = moment(p11)
    p12 = eis_convert_mhc_current_n15vana(eis_get_daily_data(files, 'MHC_N15V_AI', 3, 3, mx3, mn3), p14)
    avgp3 = moment(p12)
    p15 = eis_convert_mhc_current_rdc(eis_get_daily_data    (files, 'MHC_RDC_I',   4, 3, mx4, mn4), p14)
    avgp4 = moment(p15)

    title_str = 'MHC currents (amps)             min            max                avg'

    p5v_str  = eis_param_string('+5v digital           ', 'amps', min(p10), max(p10))
    p15v_str = eis_param_string('+15v analog           ', 'amps', min(p11), max(p11))
    n15v_str = eis_param_string('-15v analog           ', 'amps', min(p12), max(p12))
    rdc_str  = eis_param_string('RDC                   ', 'amps', min(p15), max(p15))

    if n_elements(lu) ne 0 then begin
        print, '	mhc_currents_check'
        printf, lu, title_str
        printf, lu, p5v_str  + '            ' + strtrim(string(avgp1[0],format='(F7.3)'), 0)
        printf, lu, p15v_str + '            ' + strtrim(string(avgp2[0],format='(F7.3)'), 0)
        printf, lu, n15v_str + '            ' + strtrim(string(avgp3[0],format='(F7.3)'), 0)
        printf, lu, rdc_str  + '            ' + strtrim(string(avgp4[0],format='(F7.3)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p5v_str
        print, p15v_str
        print, n15v_str
        print, rdc_str
        print
    endelse

end

pro mhc_voltages_check, files, lu
    p47 = eis_get_daily_data(files, 'MHC_GND_F_REF', 5, 1, mxp0, mnp0, base_time, end_time)
;    p1  = eis_convert_mhc_voltage_p5vdig(eis_get_daily_data (files, 'MHC_SG_OP',  1, 2, mx1, mn1), p47)
    p2  = eis_convert_mhc_voltage_p5vdig   (eis_get_daily_data(files, 'MHC_P5VD',  2, 2, mx1, mn1), p47)
    avgp1 = moment(p2)
    p3  = eis_convert_mhc_voltage_p15vana  (eis_get_daily_data(files, 'MHC_P15V_A', 3, 2, mx1, mn1), p47)
    avgp2 = moment(p3)
    p4  = eis_convert_mhc_voltage_n15vana  (eis_get_daily_data(files, 'MHC_N15V_A', 4, 2, mx1, mn1), p47)
    avgp3 = moment(p4)
    p5  = eis_convert_mhc_voltage_p15vmech (eis_get_daily_data(files, 'MHC_P15V_M',  5, 2, mx1, mn1), p47)
    avgp4 = moment(p5)
    p8  = eis_convert_mhc_voltage_p120vpzt (eis_get_daily_data(files, 'MHC_P120V_PZT', 6, 2, mx1, mn1), p47)
    avgp5 = moment(p8)
    p55 = eis_convert_mhc_voltage_pzt_drive(eis_get_daily_data(files, 'MHC_PZT_DRIVE', 7, 2, mx1, mn1), p47)
    avgp6 = moment(p55)
;    p73 = eis_convert_mhc_voltage_(eis_get_daily_data    (files, 'MHC_VAC_GAUGE',  8, 2, mx1, mn1), p47)

    title_str = 'MHC voltages (volts)            min            max                avg'

    p5v_str   = eis_param_string('+5v digital           ', 'volts', min(p2),  max(p2))
    p15v_str  = eis_param_string('+15v analog           ', 'volts', min(p3),  max(p3))
    n15v_str  = eis_param_string('-15v analog           ', 'volts', min(p4),  max(p4))
    p15vm_str = eis_param_string('+15v mech             ', 'volts', min(p5),  max(p5))
    p120v_str = eis_param_string('+120v PZT             ', 'volts', min(p8),  max(p8))
    pzt_str   = eis_param_string('PZT                   ', 'volts', min(p55), max(p55))

print, 'avgp1 = ', avgp1

    if n_elements(lu) ne 0 then begin
        print, '	mhc_voltages_check'
        printf, lu, title_str
        printf, lu, p5v_str   + '            ' + strtrim(string(avgp1[0],format='(F7.2)'), 0)
        printf, lu, p15v_str  + '            ' + strtrim(string(avgp2[0],format='(F7.2)'), 0)
        printf, lu, n15v_str  + '            ' + strtrim(string(avgp3[0],format='(F7.2)'), 0)
        printf, lu, p15vm_str + '            ' + strtrim(string(avgp4[0],format='(F7.2)'), 0)
        printf, lu, p120v_str + '            ' + strtrim(string(avgp5[0],format='(F7.2)'), 0)
        printf, lu, pzt_str   + '            ' + strtrim(string(avgp6[0],format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p5v_str
        print, p15v_str
        print, n15v_str
        print, p15vm_str
        print, p120v_str
        print, pzt_str
        print
    endelse
end

;pro mhc_gp0_temperatures, files, output, end_time
pro mhc_gp0_temperatures_check, files, lu

    title_str = 'Gp 0 temperatures (C)           min            max                avg'

    p29_arr = eis_get_daily_data(files, 'MHC_REF_THER_0', 3, 1, mxp29, mnp29, base_time, end_time)
    p30_arr = eis_get_daily_data(files, 'MHC_CAL_THER_0', 4, 1, mxp30, mnp30, base_time, end_time)
    p0_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_DB_T0',         1, 4, mxp0, mnp0, base_time, end_time), p29_arr, p30_arr)
    avgp1 = moment(p0_arr)
    p1_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_BOX_T1',        2, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    avgp2 = moment(p1_arr)
    p2_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_T2',         3, 4, mxp2, mnp2, base_time, end_time), p29_arr, p30_arr)
    avgp3 = moment(p2_arr)
    p3_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_T3',         4, 4, mxp3, mnp3, base_time, end_time), p29_arr, p30_arr)
    avgp4 = moment(p3_arr)
    p4_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_SLA_T4',        5, 4, mxp4, mnp4, base_time, end_time), p29_arr, p30_arr)
    avgp5 = moment(p4_arr)
    p5_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_SLA_T5',        6, 4, mxp5, mnp5, base_time, end_time), p29_arr, p30_arr)
    avgp6 = moment(p5_arr)
    p6_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HARNESS_T6',    7, 4, mxp6, mnp6, base_time, end_time), p29_arr, p30_arr)
    avgp7 = moment(p6_arr)
    p7_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_BASE_T7',   8, 4, mxp7, mnp7, base_time, end_time), p29_arr, p30_arr)
    avgp8 = moment(p7_arr)
    p8_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_PZT_T8',    9, 4, mxp8, mnp8, base_time, end_time), p29_arr, p30_arr)
    avgp9 = moment(p8_arr)

    p9_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_MOTOR_T9', 10, 4, mxp9, mnp9, base_time, end_time), p29_arr, p30_arr)
    avgp10 = moment(p9_arr)

    p10_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_GRA_MOTOR_T10', 11, 4, mxp10, mnp10, base_time, end_time), p29_arr, p30_arr)
    avgp11 = moment(p10_arr)

    p11_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_GRA_ASM_T11', 12, 4, mxp11, mnp11, base_time, end_time), p29_arr, p30_arr)
    avgp12 = moment(p11_arr)

    p12_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_D4_T12', 13, 4, mxp12, mnp12, base_time, end_time), p29_arr, p30_arr)
    avgp13 = moment(p12_arr)

    p0_str =  eis_param_string('Digital box  (T0)     ', 'degC', min(p0_arr), max(p0_arr))
    p1_str =  eis_param_string('Digital box  (T1)     ', 'degC', min(p1_arr), max(p1_arr))
    p2_str =  eis_param_string('Power board  (T2)     ', 'degC', min(p2_arr), max(p2_arr))
    p3_str =  eis_param_string('Power board  (T3)     ', 'degC', min(p3_arr), max(p3_arr))
    p4_str =  eis_param_string('SLA          (T4)     ', 'degC', min(p4_arr), max(p4_arr))
    p5_str =  eis_param_string('SLA          (T5)     ', 'degC', min(p5_arr), max(p5_arr))
    p6_str =  eis_param_string('Harness      (T6)     ', 'degC', min(p6_arr), max(p6_arr))
    p7_str =  eis_param_string('MIR base     (T7)     ', 'degC', min(p7_arr), max(p7_arr))
    p8_str =  eis_param_string('MIR PZT      (T8)     ', 'degC', min(p8_arr), max(p8_arr))
    p9_str =  eis_param_string('MIR motor    (T9)     ', 'degC', min(p9_arr), max(p9_arr))

    p10_str = eis_param_string('GRA motor    (T10)    ', 'degC', min(p10_arr), max(p10_arr))
    p11_str = eis_param_string('GRA assembly (T11)    ', 'degC', min(p11_arr), max(p11_arr))
    p12_str = eis_param_string('Power Board  (T12)    ', 'degC', min(p12_arr), max(p12_arr))

    if n_elements(lu) ne 0 then begin
        print, '	mhc_gp0_temperatures_check'
        printf, lu, title_str
        printf, lu, p0_str + '            ' + strtrim(string(avgp1[0],format='(F7.2)'), 0)
        printf, lu, p1_str + '            ' + strtrim(string(avgp2[0],format='(F7.2)'), 0)
        printf, lu, p2_str + '            ' + strtrim(string(avgp3[0],format='(F7.2)'), 0)
        printf, lu, p3_str + '            ' + strtrim(string(avgp4[0],format='(F7.2)'), 0)
        printf, lu, p4_str + '            ' + strtrim(string(avgp5[0],format='(F7.2)'), 0)
        printf, lu, p5_str + '            ' + strtrim(string(avgp6[0],format='(F7.2)'), 0)
        printf, lu, p6_str + '            ' + strtrim(string(avgp7[0],format='(F7.2)'), 0)
        printf, lu, p7_str + '            ' + strtrim(string(avgp8[0],format='(F7.2)'), 0)
        printf, lu, p8_str + '            ' + strtrim(string(avgp9[0],format='(F7.2)'), 0)
        printf, lu, p9_str + '            ' + strtrim(string(avgp10[0],format='(F7.2)'), 0)

        printf, lu, p10_str + '            ' + strtrim(string(avgp11[0],format='(F7.2)'), 0)
        printf, lu, p11_str + '            ' + strtrim(string(avgp12[0],format='(F7.2)'), 0)
        printf, lu, p12_str + '            ' + strtrim(string(avgp13[0],format='(F7.2)'), 0)

        printf, lu
    endif else begin
        print, title_str
        print, p0_str
        print, p1_str
        print, p2_str
        print, p3_str
        print, p4_str
        print, p5_str
        print, p6_str
        print, p7_str
        print, p8_str
        print, p9_str

        print, p10_str
        print, p11_str
        print, p12_str

        print
    endelse

end

;pro mhc_gp2_temperatures, files, output, end_time
pro mhc_gp2_temperatures_check, files, lu

    title_str = 'Gp 2 temperatures (C)           min            max                avg'

    p29_arr = eis_get_daily_data(files, 'MHC_REF_THER_0', 3, 1, mxp29, mnp29, base_time, end_time)
    p30_arr = eis_get_daily_data(files, 'MHC_CAL_THER_0', 4, 1, mxp30, mnp30, base_time, end_time)
    p0_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T0',   1, 5, mxp0,  mnp0,  base_time, end_time), p29_arr, p30_arr)
    avgp1 = moment(p0_arr)
    p1_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T1',   2, 5, mxp1,  mnp1,  base_time, end_time), p29_arr, p30_arr)
    avgp2 = moment(p1_arr)
    p2_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T2',   3, 5, mxp2,  mnp2,  base_time, end_time), p29_arr, p30_arr)
    avgp3 = moment(p2_arr)
    p3_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T3',   4, 5, mxp3,  mnp3,  base_time, end_time), p29_arr, p30_arr)
    avgp4 = moment(p3_arr)
    p4_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T4',   5, 5, mxp4,  mnp4,  base_time, end_time), p29_arr, p30_arr)
    avgp5 = moment(p4_arr)
    p5_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T5',   6, 5, mxp5,  mnp5,  base_time, end_time), p29_arr, p30_arr)
    avgp6 = moment(p5_arr)
    p6_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T6',   7, 5, mxp6,  mnp6,  base_time, end_time), p29_arr, p30_arr)
    avgp7 = moment(p6_arr)
    p7_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T7',   8, 5, mxp7,  mnp7,  base_time, end_time), p29_arr, p30_arr)
    avgp8 = moment(p7_arr)
    p8_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T8',   9, 5, mxp8,  mnp8,  base_time, end_time), p29_arr, p30_arr)
    avgp9 = moment(p8_arr)
    p9_arr  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T9',  10, 5, mxp9,  mnp9,  base_time, end_time), p29_arr, p30_arr)
    avgp10 = moment(p9_arr)
    p10_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T10', 11, 5, mxp10, mnp10, base_time, end_time), p29_arr, p30_arr)
    avgp11 = moment(p10_arr)
    p11_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T11', 12, 5, mxp11, mnp11, base_time, end_time), p29_arr, p30_arr)
    avgp12 = moment(p11_arr)
    p12_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T12', 13, 5, mxp12, mnp12, base_time, end_time), p29_arr, p30_arr)
    avgp13 = moment(p12_arr)
    p13_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T13', 14, 5, mxp13, mnp13, base_time, end_time), p29_arr, p30_arr)
    avgp14 = moment(p13_arr)
    p14_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T14', 15, 5, mxp14, mnp14, base_time, end_time), p29_arr, p30_arr)
    avgp15 = moment(p14_arr)
    p15_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T15', 16, 5, mxp15, mnp15, base_time, end_time), p29_arr, p30_arr)
    avgp16 = moment(p15_arr)

    p0_str  = eis_param_string('Heater zone T0        ', 'degC', min(p0_arr),  max(p0_arr))
    p1_str  = eis_param_string('Heater zone T1        ', 'degC', min(p1_arr),  max(p1_arr))
    p2_str  = eis_param_string('Heater zone T2        ', 'degC', min(p2_arr),  max(p2_arr))
    p3_str  = eis_param_string('Heater zone T3        ', 'degC', min(p3_arr),  max(p3_arr))
    p4_str  = eis_param_string('Heater zone T4        ', 'degC', min(p4_arr),  max(p4_arr))
    p5_str  = eis_param_string('Heater zone T5        ', 'degC', min(p5_arr),  max(p5_arr))
    p6_str  = eis_param_string('Heater zone T6        ', 'degC', min(p6_arr),  max(p6_arr))
    p7_str  = eis_param_string('Heater zone T7        ', 'degC', min(p7_arr),  max(p7_arr))
    p8_str  = eis_param_string('Heater zone T8        ', 'degC', min(p8_arr),  max(p8_arr))
    p9_str  = eis_param_string('Heater zone T9        ', 'degC', min(p9_arr),  max(p9_arr))
    p10_str = eis_param_string('Heater zone T10       ', 'degC', min(p10_arr), max(p10_arr))
    p11_str = eis_param_string('Heater zone T11       ', 'degC', min(p11_arr), max(p11_arr))
    p12_str = eis_param_string('Heater zone T12       ', 'degC', min(p12_arr), max(p12_arr))
    p13_str = eis_param_string('Heater zone T13       ', 'degC', min(p13_arr), max(p13_arr))
    p14_str = eis_param_string('Heater zone T14       ', 'degC', min(p14_arr), max(p14_arr))
    p15_str = eis_param_string('Heater zone T15       ', 'degC', min(p15_arr), max(p15_arr))

    if n_elements(lu) ne 0 then begin
        print, '	mhc_gp2_temperatures_check'
        printf, lu, title_str
        printf, lu, p0_str + '            ' + strtrim(string(avgp1[0],format='(F7.2)'), 0)
        printf, lu, p1_str + '            ' + strtrim(string(avgp2[0],format='(F7.2)'), 0)
        printf, lu, p2_str + '            ' + strtrim(string(avgp3[0],format='(F7.2)'), 0)
        printf, lu, p3_str + '            ' + strtrim(string(avgp4[0],format='(F7.2)'), 0)
        printf, lu, p4_str + '            ' + strtrim(string(avgp5[0],format='(F7.2)'), 0)
        printf, lu, p5_str + '            ' + strtrim(string(avgp6[0],format='(F7.2)'), 0)
        printf, lu, p6_str + '            ' + strtrim(string(avgp7[0],format='(F7.2)'), 0)
        printf, lu, p7_str + '            ' + strtrim(string(avgp8[0],format='(F7.2)'), 0)
        printf, lu, p8_str + '            ' + strtrim(string(avgp9[0],format='(F7.2)'), 0)
        printf, lu, p9_str + '            ' + strtrim(string(avgp10[0],format='(F7.2)'), 0)
        printf, lu, p10_str + '            ' + strtrim(string(avgp11[0],format='(F7.2)'), 0)
        printf, lu, p11_str + '            ' + strtrim(string(avgp12[0],format='(F7.2)'), 0)
        printf, lu, p12_str + '            ' + strtrim(string(avgp13[0],format='(F7.2)'), 0)
        printf, lu, p13_str + '            ' + strtrim(string(avgp14[0],format='(F7.2)'), 0)
        printf, lu, p14_str + '            ' + strtrim(string(avgp15[0],format='(F7.2)'), 0)
        printf, lu, p15_str + '            ' + strtrim(string(avgp16[0],format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p0_str
        print, p1_str
        print, p2_str
        print, p3_str
        print, p4_str
        print, p5_str
        print, p6_str
        print, p7_str
        print, p8_str
        print, p9_str
        print, p10_str
        print, p11_str
        print, p12_str
        print, p13_str
        print, p14_str
        print, p15_str
        print
    endelse

end

;pro mhc_mechanisms, files, output, end_time
pro mhc_mechanisms_check, files, lu

    tmp = eis_get_daily_data(files, 'MHC_GRA_POS_AN',     1, 6, mx0, mn0, base_time, end_time)
    tmp = eis_get_daily_data(files, 'MHC_SS_POS_STEPS',   2, 6, mx1, mn1)
    tmp = eis_get_daily_data(files, 'MHC_CMIR_POS_STEPS', 3, 6, mx2, mn2)
    tmp = eis_get_daily_data(files, 'MHC_CMIR_POS',       4, 6, mx3, mn3)
    tmp = eis_get_daily_data(files, 'MHC_SS_POS',         5, 6, mx4, mn4)
    tmp = eis_get_daily_data(files, 'MHC_GRA_SW_POS',     6, 6, mx5, mn5)

    title_str = 'MHC mechanisms                  min            max'

    format_str = 'zcount'

    p0_str = eis_param_string('GRA RDC Pos           ', format_str, mn0, mx0)
    p1_str = eis_param_string('SLA pos (steps)       ', format_str, mn1, mx1)
    p2_str = eis_param_string('CMIR pos (steps)      ', format_str, mn2, mx2)
    p3_str = eis_param_string('CMIR RDC Pos          ', format_str, mn3, mx3)
    p4_str = eis_param_string('SS RDC Pos            ', format_str, mn4, mx4)
    p5_str = eis_param_string('GRA S/w Pos           ', format_str, mn5, mx5)

    if n_elements(lu) ne 0 then begin
        print, '	mhc_mechanisms_check'
        printf, lu, title_str
        printf, lu, p0_str
        printf, lu, p1_str
        printf, lu, p2_str
        printf, lu, p3_str
        printf, lu, p4_str
        printf, lu, p5_str
        printf, lu
    endif

end

;pro mhc_status, files, output, end_time
pro mhc_status_check, files, lu

    tmp = eis_get_daily_data(files, 'MHC_MOTOR_OPT_ENC', 1, 7, mx0, mn0, base_time, end_time)
    tmp = eis_get_daily_data(files, 'MHC_ACT_OPT_ENC',   2, 7, mx1, mn1)
    tmp = eis_get_daily_data(files, 'MHC_ACT_STAT',      3, 7, mx2, mn2)
    tmp = eis_get_daily_data(files, 'MHC_CAL_SRC_STAT',  4, 7, mx3, mn3)
    tmp = eis_get_daily_data(files, 'MHC_HTR_STAT',      5, 7, mx4, mn4)
    tmp = eis_get_daily_data(files, 'MHC_SEQ_MSW',       6, 7, mx5, mn5)
    tmp = eis_get_daily_data(files, 'MHC_SEQ_LSW',       7, 7, mx6, mn6)
    tmp = eis_get_daily_data(files, 'MHC_SYS_STAT',      8, 7, mx7, mn7)

    title_str = 'MHC status                      min            max'

    format_str = 'zcount'

    p0_str = eis_param_string('Motor Opt Enc         ', format_str, mn0, mx0)
    p1_str = eis_param_string('Actuator Enc          ', format_str, mn1, mx1)
    p2_str = eis_param_string('Actuator Status       ', format_str, mn2, mx2)
    p3_str = eis_param_string('Cal Source Status     ', format_str, mn3, mx3)
    p4_str = eis_param_string('Heater Status         ', format_str, mn4, mx4)
    p5_str = eis_param_string('Seq Msw               ', format_str, mn5, mx5)
    p6_str = eis_param_string('Seq Lsw               ', format_str, mn6, mx6)
    p7_str = eis_param_string('System Status         ', format_str, mn7, mx7)

    if n_elements(lu) ne 0 then begin
        print, '	mhc_status_check'
        printf, lu, title_str
        printf, lu, p0_str
        printf, lu, p1_str
        printf, lu, p2_str
        printf, lu, p3_str
        printf, lu, p4_str
        printf, lu, p5_str
        printf, lu, p6_str
        printf, lu, p7_str
        printf, lu
    endif
end

pro mhc_counters_check, files, lu

    p = eis_get_daily_data(files, 'MHC_EXP_T1',   1, 8, mx0, mn0, base_time, end_time)
    p = eis_get_daily_data(files, 'MHC_EXP_T2',   2, 8, mx1, mn1)
    p = eis_get_daily_data(files, 'MHC_CMD_REC',  3, 8, mx2, mn2)
    p = eis_get_daily_data(files, 'MHC_CMD_ACK',  4, 8, mx3, mn3)
    n = eis_get_daily_data(files, 'MHC_CMD_NACK', 5, 8, mx4, mn4)
    c = eis_get_daily_data(files, 'MHC_CMD_ID',   6, 8, mx5, mn5)
    p = eis_get_daily_data(files, 'MHC_TIME_MSW', 7, 8, mx6, mn6)
    p = eis_get_daily_data(files, 'MHC_TIME_LSW', 8, 8, mx7, mn7)

    title_str = 'MHC counters                    min            max'

    p0_str      = eis_param_string('Exp T1                ', 'zcount', mn0, mx0)
    p1_str      = eis_param_string('Exp T2                ', 'zcount', mn1, mx1)
    cmd_rec_str = eis_param_string('Cmd rec               ', 'count',  mn2, mx2)
    cmd_ack_str = eis_param_string('Cmd ack               ', 'count',  mn3, mx3)
    nack_str    = eis_param_string('Cmd nack              ', 'count',  mn4, mx4)
    p5_str      = eis_param_string('Cmd id                ', 'zcount', mn5, mx5)
    p6_str      = eis_param_string('Time MSW              ', 'zcount', mn6, mx6)
    p7_str      = eis_param_string('Time LSW              ', 'zcount', mn7, mx7)

    nne = n_elements(n)
    discontinuities = where(n[0:nne-2]-n[1:nne-1] ne 0, dcount)

    if n_elements(lu) ne 0 then begin
        print, '	mhc_counters_check'
        printf, lu, title_str
        printf, lu, p0_str
        printf, lu, p1_str
        printf, lu, cmd_rec_str
        printf, lu, cmd_ack_str
        printf, lu, nack_str
        printf, lu, p5_str
        printf, lu, p6_str
        printf, lu, p7_str
        if dcount ne 0 then begin
            if dcount eq 1 then nack_str = 'NACK' else nack_str = 'NACKS'
            st_in_tai = anytim2tai(base_time)
            printf, lu, '	' + strtrim(string(dcount),2) + ' ' + nack_str + ':'
            for i = 0, dcount - 1 do begin
                event_index = discontinuities[i]
                event_time  = tai2utc(st_in_tai + (10 * (event_index + 1)),/ccsds)
                printf, lu, '		' + event_time + ' : ' + strtrim(string(n[event_index]),2) + ' -> ' + strtrim(string(n[event_index + 1]),2)
             endfor
            printf, lu, c[discontinuities], format='(Z04)'
            for i = 0, dcount - 1 do begin
                event_index = discontinuities[i]
                printf, lu, c[event_index], format = '(Z04)'
                if not (event_index ge nne) then printf, lu, c[event_index + 1], format = '(Z04)'
             endfor
        endif
        printf, lu
    endif else begin
        print, title_str
        print, cmd_rec_str
        print, cmd_ack_str
        print, nack_str
;        if dcount ne 0 then begin

;        endif
        print
    endelse

end

function eis_convert_qcm_temperature, raw, index, param
    gain_factor1 = -7.
    gain_factor2 = 1./3.
    scale_factor = 305.2e-6

;    ref_params = where(index eq 2)
    ref_params = where(index eq 3)
    ref = param[ref_params]

;    led_params = where(index eq 5)
    led_params = where(index eq 6)
    led = param[led_params]

    cal_led2_current = led - '4000'X

    ;;; This is approx 16 times too small?????
    mhc_voltage_ref = ref
;    mhc_voltage_ref[*] = 16 * (moment(ref))[0] ; get average value

; Step 2
    drive_voltage = abs(scale_factor * gain_factor1 * (mhc_voltage_ref - cal_led2_current))

; Step 3
    rtd_voltage = (scale_factor * gain_factor2) * (raw[led_params] - cal_led2_current)

; Step 4
    rtd_resistance = abs((10000. * rtd_voltage) / (drive_voltage - rtd_voltage))

; Step 5
    t = (rtd_resistance - 470.) / 1.843 ; 1.843 = 3.92191 * 470
    return, congrid(t, n_elements(raw)) ; expand # values to whole day
end

pro mhc_qcm_status, files, lu, out_dir
print, '	mhc_qcm_status_check'
    qcm_msw = eis_get_daily_data(files, 'MHC_QCM_MSW',       1,  9, mx0, mn0, st, et)
    qcm_lsw = eis_get_daily_data(files, 'MHC_QCM_LSW',       2,  9, mx1, mn1)
    qcm_t1  = eis_get_daily_data(files, 'MHC_QCM1_TEMP',     3,  9, mx2, mn2)
    qcm_t2  = eis_get_daily_data(files, 'MHC_QCM2_TEMP',     4,  9, mx3, mn3)
    qcm_int = eis_get_daily_data(files, 'MHC_QCM_INT_CLOCK', 5,  9, mx4, mn4)
    htr     = eis_get_daily_data(files, 'MHC_HTR_STAT',      5,  7, mx5, mn5)
    subi    = eis_get_daily_data(files, 'MHC_PERFORM_INDEX', 1, 10, mx6, mn6)
    subp    = eis_get_daily_data(files, 'MHC_PERFORM_PARM',  2, 10, mx6, mn6)

    qcm1_on = where(((htr and '1000'X) eq '1000'X), qcm1_on_count)
    qcm2_on = where(((htr and '2000'X) eq '2000'X), qcm2_on_count)

    ; Convert start time to atomic time
    st_in_tai = anytim2tai(st)

    ; Join the 2 count words together
    c = ishft(long(qcm_msw), 16) or qcm_lsw

    if qcm1_on_count gt 0 then begin
        ; Don't bother with qcm1 temperature as it is broken. Use ets11
        ; mhc_hz_t11 (d1mon11)
;        qcm1_temps = eis_convert_qcm_temperature(qcm_t1, subi, subp)
        p29_arr = eis_get_daily_data(files, 'MHC_REF_THER_0', 3, 1, mxp29, mnp29, base_time, end_time)
        p30_arr = eis_get_daily_data(files, 'MHC_CAL_THER_0', 4, 1, mxp30, mnp30, base_time, end_time)
        qcm1_temps = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T11', 12, 5, mxp11, mnp11, base_time, end_time), p29_arr, p30_arr)

print, '	    qcm1 turned on'
        ;
        ; Open up the qcm1 measurement log file
        ;
        openw, lun, out_dir + '/qcm1_log.txt', /get_lun, /append

        ;
        ; There may be multiple instances of qcm1 testing during the day,
        ; so check the element differences in the where array
        ;
        groups = where(eis_count_check(qcm1_on) gt 1, gp_count)

        if gp_count eq 0 then begin
print,'		    qcm1 on once'
            freq = qcm_int[qcm1_on] / (c[qcm1_on] * 1e-6)
            qcm1_on_offset = qcm1_on[0] * 10
            qcm1_on_secs   = st_in_tai + qcm1_on_offset
            qcm1_on_time   = tai2utc(qcm1_on_secs,/ccsds)
;;;            printf, lun, qcm1_on_time, freq[0]
            printf, lun, qcm1_on_time, freq[0], (qcm1_temps[qcm1_on])[0]
        endif else begin
print,'		    qcm1 on multiple times'

            num_qcm1_on = n_elements(qcm1_on) - 1
            start_points = [0]
            start_points = [start_points, groups + 1]
            end_points = groups
            end_points = [end_points, num_qcm1_on]
            for gp = 0, gp_count  do begin
                start = start_points[gp]
                last  = end_points[gp]
                freq = qcm_int[qcm1_on[start:last]] / (c[qcm1_on[start:last]] * 1e-6)
                qcm1_on_offset = qcm1_on[start] * 10
                qcm1_on_secs   = st_in_tai + qcm1_on_offset
                qcm1_on_time   = tai2utc(qcm1_on_secs,/ccsds)
;;;                printf, lun, qcm1_on_time, freq[n_elements(freq) - 1]
                printf, lun, qcm1_on_time, freq[n_elements(freq) - 1], (qcm1_temps[qcm1_on[start:last]])[0]
            endfor
;            start = 0
;            for gp = 0, gp_count - 1 do begin
;                last = gp eq gp_count - 1 ? n_elements(qcm1_on) - 1 : groups[gp]
;                freq = qcm_int[start:last] / (c[start:last] * 1e-6)
;                qcm1_on_offset = qcm1_on[start] * 10
;                qcm1_on_secs   = st_in_tai + qcm1_on_offset
;                qcm1_on_time   = tai2utc(qcm1_on_secs,/ccsds)
;                printf, lun, qcm1_on_time, freq[0]
;                start = groups[gp] + 1
;            endfor
        endelse

        close, lun
        free_lun, lun

    endif

    if qcm2_on_count gt 0 then begin
        qcm2_temps = eis_convert_qcm_temperature(qcm_t2, subi, subp)

print,'		qcm2 turned on'
        ;
        ; Open up the qcm2 measurement log file
        ;
        openw, lun, out_dir + '/qcm2_log.txt', /get_lun, /append

        ;
        ; There may be multiple instances of qcm1 testing during the day,
        ; so check the element differences in the where array
        ;
        groups = where(eis_count_check(qcm2_on) gt 1, gp_count)

        if gp_count eq 0 then begin
print,'		    qcm2 on once'
            freq = qcm_int[qcm2_on] / (c[qcm2_on] * 1e-6)
            qcm2_on_offset = qcm2_on[0] * 10
            qcm2_on_secs   = st_in_tai + qcm2_on_offset
            qcm2_on_time   = tai2utc(qcm2_on_secs,/ccsds)
;;;            printf, lun, qcm2_on_time, freq[0]
            printf, lun, qcm2_on_time, freq[0], (qcm2_temps[qcm2_on])[0]
        endif else begin
print,'		    qcm2 on multiple times'

            num_qcm2_on = n_elements(qcm2_on) - 1
            start_points = [0]
            start_points = [start_points, groups + 1]
            end_points = groups
            end_points = [end_points, num_qcm2_on]
            for gp = 0, gp_count  do begin
                start = start_points[gp]
                last  = end_points[gp]
                freq = qcm_int[qcm2_on[start:last]] / (c[qcm2_on[start:last]] * 1e-6)
                qcm2_on_offset = qcm2_on[start] * 10
                qcm2_on_secs   = st_in_tai + qcm2_on_offset
                qcm2_on_time   = tai2utc(qcm2_on_secs,/ccsds)
;;;                printf, lun, qcm2_on_time, freq[n_elements(freq) - 1]
                printf, lun, qcm2_on_time, freq[n_elements(freq) - 1], (qcm2_temps[qcm2_on[start:last]])[0]
            endfor
;            start = 0
;            for gp = 0, gp_count - 1 do begin
;                last = gp eq gp_count - 1 ? n_elements(qcm2_on) - 1 : groups[gp]
;                freq = qcm_int[start:last] / (c[start:last] * 1e-6)
;                qcm2_on_offset = qcm2_on[start] * 10
;                qcm2_on_secs   = st_in_tai + qcm2_on_offset
;                qcm2_on_time   = tai2utc(qcm2_on_secs,/ccsds)
;                printf, lun, qcm2_on_time, freq[0]
;                start = groups[gp] + 1
;            endfor
        endelse

        close, lun
        free_lun, lun

    endif

end

pro mhc_subcomm, files, output, end_time

    p0 = eis_get_daily_data(files, 'MHC_PERFORM_INDEX', 1, 10, mxp0, mnp0, base_time, end_time)
    p1 = eis_get_daily_data(files, 'MHC_PERFORM_PARM',  2, 10, mx1, mn1)


end

pro mhc_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME', 1,  11, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  11, maxp2, minp2)

        
end

pro eis_status_sts3_check, dir, lu

  print, 'eis_status_sts3_check' 

    files = findfile(dir + 'eis_sts3_*fits*', count=count)
    if count eq 0 then begin
        print, 'eis_status_sts3_check' 
        print, '	No files'
        return
    endif

    qcm_dir = getenv('HOME') + '/work/localdata/log/status/qcm'
     
    print, 'eis_status_sts3_check' 
    if n_elements(lu) ne 0 then begin
        mhc_voltages_check,         files, lu
        mhc_currents_check,         files, lu
        mhc_gp0_temperatures_check, files, lu
        mhc_gp2_temperatures_check, files, lu
        mhc_mechanisms_check,       files, lu
        mhc_status_check,           files, lu
        mhc_counters_check,         files, lu
;        mhc_subcomm,          files, lu
;        mhc_spacecraft,       files, lu
        mhc_qcm_status,             files, lu, qcm_dir
    endif else begin
        mhc_voltages_check,         files
        mhc_currents_check,         files
        mhc_gp0_temperatures_check, files
        mhc_gp2_temperatures_check, files
        mhc_mechanisms_check,       files
        mhc_status_check,           files
        mhc_counters_check,         files
;        mhc_qcm_status,       files
;        mhc_subcomm,          files
;        mhc_spacecraft,       files
;        mhc_qcm_status,       files, lu, qcm_dir
    endelse

end
