;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006 v1.0 mcrw wrote
;       15/Nov/2006  v1.1 mcrw minor corrections
;       03/Dec/2006  v1.2 mcrw minor corrections
;
;-------------------------------------------------------------------------------------------------
pro hk1_status_parameters, files, output, end_time

    p0  = eis_get_daily_data(files, 'HK1_EIS_ON_OFF',   1,  2, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files, 'HK1_EIS_A_HTR_ED', 2,  2, maxp2,  minp2)
    p2  = eis_get_daily_data(files, 'HK1_EIS_B_HTR_ED', 3,  2, maxp3,  minp3)
    p3  = eis_get_daily_data(files, 'HK1_EIS_C_HTR_ED', 4,  2, maxp4,  minp4)

    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/eis_hk1_status_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='HK1_EIS_ON_OFF',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='HK1_EIS_A_HTR_ED',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='HK1_EIS_B_HTR_ED',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp4-1,maxp4+1], $
      title='HK1_EIS_C_HTR_ED',ytitle='Raw',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro hk1_mdp_parameters, files, output, end_time

    p0  = eis_get_daily_data(files,'HK1_DIST_28V_VOLT', 1,  3, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'HK1_DIST_28V_CUR',  2,  3, maxp2,  minp2)
    p2  = eis_get_daily_data(files,'EIS_DATA_RATE',     3,  3, maxp3,  minp3)

    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/eis_hk1_mdp_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='HK1_DIST_28V_VOLT',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='HK1_DIST_28V_CUR',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='EIS_DATA_RATE',ytitle='Raw',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro hk1_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME',        1,  4, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  4, maxp2, minp2)

;;;    x = lindgen(n_elements(p0))*10
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/hk1_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_hk1_conversions, dir, output, end_time

    files = findfile(dir + 'eis_hk1_*fits', count=count)
    if count eq 0 then begin
        print, 'eis_status_hk1_conversions : No files'
        return
    endif

    hk1_status_parameters, files, output, end_time
    hk1_mdp_parameters,    files, output, end_time
    hk1_spacecraft,        files, output, end_time

end
