;+
; NAME: eis_status_sts3_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006	mcrw wrote
;       21/Sept/2006    mcrw v2.0
;
;-------------------------------------------------------------------------------------------------

pro mhc_currents, files, output, end_time

    p14 = eis_get_daily_data(files, 'MHC_GND_I_REF', 2, 1, mxp0, mnp0, base_time, end_time)
    p10 = eis_convert_mhc_current_p5vdig(eis_get_daily_data (files, 'MHC_P5V_DI',  1, 3, mx1, mn1), p14)
    p11 = eis_convert_mhc_current_p15vana(eis_get_daily_data(files, 'MHC_P15V_AI', 2, 3, mx1, mn1), p14)
    p12 = eis_convert_mhc_current_n15vana(eis_get_daily_data(files, 'MHC_N15V_AI', 3, 3, mx1, mn1), p14)
    p15 = eis_convert_mhc_current_rdc(eis_get_daily_data    (files, 'MHC_RDC_I',   4, 3, mx1, mn1), p14)

    x = lindgen(n_elements(p14))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_currents.ps'
    !p.multi=[0,1,3]

    utplot,x,p10,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC P5V DI',ytitle='Amps',charsize=cs  
    utplot,x,p11,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC P15V AI',ytitle='Amps',charsize=cs  
    utplot,x,p12,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC N15V AI',ytitle='Amps',charsize=cs  
    utplot,x,p15,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC RDC I',ytitle='Amps',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_voltages, files, output, end_time

    p47 = eis_get_daily_data(files, 'MHC_GND_F_REF', 5, 1, mxp0, mnp0, base_time, end_time)
;    p1  = eis_convert_mhc_voltage_p5vdig(eis_get_daily_data (files, 'MHC_SG_OP',  1, 2, mx1, mn1), p47)
    p2  = eis_convert_mhc_voltage_p5vdig   (eis_get_daily_data(files, 'MHC_P5VD',  2, 2, mx1, mn1), p47)
    p3  = eis_convert_mhc_voltage_p15vana  (eis_get_daily_data(files, 'MHC_P15V_A', 3, 2, mx1, mn1), p47)
    p4  = eis_convert_mhc_voltage_n15vana  (eis_get_daily_data(files, 'MHC_N15V_A', 4, 2, mx1, mn1), p47)
    p5  = eis_convert_mhc_voltage_p15vmech (eis_get_daily_data(files, 'MHC_P15V_M',  5, 2, mx1, mn1), p47)
    p8  = eis_convert_mhc_voltage_p120vpzt (eis_get_daily_data(files, 'MHC_P120V_PZT', 6, 2, mx1, mn1), p47)
    p55 = eis_convert_mhc_voltage_pzt_drive(eis_get_daily_data(files, 'MHC_PZT_DRIVE', 7, 2, mx1, mn1), p47)
;    p73 = eis_convert_mhc_voltage_(eis_get_daily_data    (files, 'MHC_VAC_GAUGE',  8, 2, mx1, mn1), p47)

    x = lindgen(n_elements(p47))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_voltages.ps'
    !p.multi=[0,1,3]

    utplot,x,p2,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC P5V DIGITAL',ytitle='Volts',charsize=cs  

    utplot,x,p3,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC P15V ANALOG',ytitle='Volts',charsize=cs  

    utplot,x,p4,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC N15V ANALOG',ytitle='Volts',charsize=cs  

    utplot,x,p5,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC P15V MECH',ytitle='Volts',charsize=cs  

    utplot,x,p8,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC P120V PZT',ytitle='Volts',charsize=cs  

    utplot,x,p55,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC PZT DRIVE',ytitle='Volts',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_gp0_temperatures, files, output, end_time

    p29_arr = eis_get_daily_data(files, 'MHC_REF_THER_0', 3, 1, mxp0, mnp0, base_time, end_time)
    p30_arr = eis_get_daily_data(files, 'MHC_CAL_THER_0', 4, 1, mxp0, mnp0, base_time, end_time)
    p0_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_DB_T0', 1, 4, mxp0, mnp0, base_time, end_time), p29_arr, p30_arr)
    p1_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_BOX_T1', 2, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p2_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_T2', 3, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p3_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_T3', 4, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p4_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_SLA_T4', 5, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p5_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_SLA_T5', 6, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p6_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HARNESS_T6', 7, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p7_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_BASE_T7', 8, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p8_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_PZT_T8', 9, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p9_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_MOTOR_T9', 10, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    
    p10_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_GRA_MOTOR_T10', 11, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p11_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_GRA_ASM_T11', 12, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p12_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_D4_T12', 13, 4, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)

    x = lindgen(n_elements(p0_arr))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_gp0_temperatures.ps'
    !p.multi=[0,1,3]

    utplot,x,p0_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC DB T0',ytitle='Degrees C',charsize=cs  

    utplot,x,p1_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC BOX T1',ytitle='Degrees C',charsize=cs  

    utplot,x,p2_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC PB T2',ytitle='Degrees C',charsize=cs  

    utplot,x,p3_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC PB T3',ytitle='Degrees C',charsize=cs  

    utplot,x,p4_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC SLA T4',ytitle='Degrees C',charsize=cs  

    utplot,x,p5_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC SLA T5',ytitle='Degrees C',charsize=cs  

    utplot,x,p6_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_HARNESS_T6',ytitle='Degrees C',charsize=cs  

    utplot,x,p7_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_MIR_BASE_T7',ytitle='Degrees C',charsize=cs  

    utplot,x,p8_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_MIR_PZT_T8',ytitle='Degrees C',charsize=cs  

    utplot,x,p9_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_MIR_MOTOR_T9',ytitle='Degrees C',charsize=cs  

    utplot,x,p10_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_GRA_MOTOR_T10',ytitle='Degrees C',charsize=cs  

    utplot,x,p11_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_GRA_ASM_T11',ytitle='Degrees C',charsize=cs  

    utplot,x,p12_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_PB_D4_T12',ytitle='Degrees C',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_gp2_temperatures, files, output, end_time

    p29_arr = eis_get_daily_data(files, 'MHC_REF_THER_0', 3, 1, mxp0, mnp0, base_time, end_time)
    p30_arr = eis_get_daily_data(files, 'MHC_CAL_THER_0', 4, 1, mxp0, mnp0, base_time, end_time)
    p0_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T0', 1, 5, mxp0, mnp0, base_time, end_time), p29_arr, p30_arr)
    p1_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T1', 2, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p2_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T2', 3, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p3_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T3', 4, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p4_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T4', 5, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p5_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T5', 6, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p6_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T6', 7, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p7_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T7', 8, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p8_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T8', 9, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p9_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T9', 10, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p10_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T10', 11, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p11_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T11', 12, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p12_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T12', 13, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p13_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T13', 14, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p14_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T14', 15, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    p15_arr = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HZ_T15', 16, 5, mxp1, mnp1, base_time, end_time), p29_arr, p30_arr)
    
    x = lindgen(n_elements(p0_arr))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_gp2_temperatures.ps'
    !p.multi=[0,1,3]
;;;    !p.multi=[0,2,3]

    utplot,x,p0_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T0',ytitle='Degrees C',charsize=cs  

    utplot,x,p1_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T1',ytitle='Degrees C',charsize=cs  

    utplot,x,p2_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T2',ytitle='Degrees C',charsize=cs  

    utplot,x,p3_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T3',ytitle='Degrees C',charsize=cs  

    utplot,x,p4_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T4',ytitle='Degrees C',charsize=cs  

    utplot,x,p5_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T5',ytitle='Degrees C',charsize=cs  

    utplot,x,p6_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_HZ_T6',ytitle='Degrees C',charsize=cs  

    utplot,x,p7_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_HZ_T7',ytitle='Degrees C',charsize=cs  

    utplot,x,p8_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_HZ_T8',ytitle='Degrees C',charsize=cs  

    utplot,x,p9_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T9',ytitle='Degrees C',charsize=cs  

    utplot,x,p10_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T10',ytitle='Degrees C',charsize=cs  

    utplot,x,p11_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T11',ytitle='Degrees C',charsize=cs  

    utplot,x,p12_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T12',ytitle='Degrees C',charsize=cs  

    utplot,x,p13_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T13',ytitle='Degrees C',charsize=cs  

    utplot,x,p14_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T14',ytitle='Degrees C',charsize=cs  

    utplot,x,p15_arr,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC HZ T15',ytitle='Degrees C',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_mechanisms, files, output, end_time

    p0 = eis_get_daily_data(files, 'MHC_GRA_POS_AN',     1, 6, mxp0, mnp0, base_time, end_time)
    p1 = eis_get_daily_data(files, 'MHC_SS_POS_STEPS',   2, 6, mx1, mn1)
    p2 = eis_get_daily_data(files, 'MHC_CMIR_POS_STEPS', 3, 6, mx1, mn1)
    p3 = eis_get_daily_data(files, 'MHC_CMIR_POS',       4, 6, mx1, mn1)
    p4 = eis_get_daily_data(files, 'MHC_SS_POS',         5, 6, mx1, mn1)
    p5 = eis_get_daily_data(files, 'MHC_GRA_SW_POS',     6, 6, mx1, mn1)

    x = lindgen(n_elements(p0))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_mechanisms.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_GRA_POS_AN',ytitle='Raw',charsize=cs  

    utplot,x,p1,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_SS_POS_STEPS',ytitle='Raw',charsize=cs  

    utplot,x,p2,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_CMIR_POS_STEPS',ytitle='Raw',charsize=cs  

    utplot,x,p3,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_CMIR_POS',ytitle='Raw',charsize=cs  

    utplot,x,p4,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_SS_POS',ytitle='Raw',charsize=cs  

    utplot,x,p5,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_GRA_SW_POS',ytitle='Raw',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_status, files, output, end_time

    p0 = eis_get_daily_data(files, 'MHC_MOTOR_OPT_ENC', 1, 7, mxp0, mnp0, base_time, end_time)
    p1 = eis_get_daily_data(files, 'MHC_ACT_OPT_ENC',   2, 7, mx1, mn1)
    p2 = eis_get_daily_data(files, 'MHC_ACT_STAT',      3, 7, mx1, mn1)
    p3 = eis_get_daily_data(files, 'MHC_CAL_SRC_STAT',  4, 7, mx1, mn1)
    p4 = eis_get_daily_data(files, 'MHC_HTR_STAT',      5, 7, mx1, mn1)
    p5 = eis_get_daily_data(files, 'MHC_SEQ_MSW',       6, 7, mx1, mn1)
    p6 = eis_get_daily_data(files, 'MHC_SEQ_LSW',       7, 7, mx1, mn1)
    p7 = eis_get_daily_data(files, 'MHC_SYS_STAT',      8, 7, mx1, mn1)

    x = lindgen(n_elements(p0))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_status.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_MOTOR_OPT_ENC',ytitle='Raw',charsize=cs  

    utplot,x,p1,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_ACT_OPT_ENC',ytitle='Raw',charsize=cs  

    utplot,x,p2,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_ACT_STAT',ytitle='Raw',charsize=cs  

    utplot,x,p3,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_CAL_SRC_STAT',ytitle='Raw',charsize=cs  

    utplot,x,p4,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_HTR_STAT',ytitle='Raw',charsize=cs  

    utplot,x,p5,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_SEC_MSW',ytitle='Raw',charsize=cs  

    utplot,x,p6,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_SEC_LSW',ytitle='Raw',charsize=cs  

    utplot,x,p7,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_SYS_STAT',ytitle='Raw',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_counters, files, output, end_time

    p0 = eis_get_daily_data(files, 'MHC_EXP_T1',   1, 8, mxp0, mnp0, base_time, end_time)
    p1 = eis_get_daily_data(files, 'MHC_EXP_T2',   2, 8, mx1, mn1)
    p2 = eis_get_daily_data(files, 'MHC_CMD_REC',  3, 8, mx1, mn1)
    p3 = eis_get_daily_data(files, 'MHC_CMD_ACK',  4, 8, mx1, mn1)
    p4 = eis_get_daily_data(files, 'MHC_CMD_NACK', 5, 8, mx1, mn1)
    p5 = eis_get_daily_data(files, 'MHC_CMD_ID',   6, 8, mx1, mn1)
    p6 = eis_get_daily_data(files, 'MHC_TIME_MSW', 7, 8, mx1, mn1)
    p7 = eis_get_daily_data(files, 'MHC_TIME_LSW', 8, 8, mx1, mn1)

    x = lindgen(n_elements(p0))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_counters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC EXP T1',ytitle='',charsize=cs  

    utplot,x,p1,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC EXP T2',ytitle='',charsize=cs  

    utplot,x,p2,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC CMD REC',ytitle='',charsize=cs  

    utplot,x,p3,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC CMD ACK',ytitle='',charsize=cs  

    utplot,x,p4,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC CMD NACK',ytitle='',charsize=cs  

    utplot,x,p5,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC CMD ID',ytitle='',charsize=cs  

    utplot,x,p6,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC TIME MSW',ytitle='',charsize=cs  

    utplot,x,p7,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC TIME LSW',ytitle='',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_qcm_status, files, output, end_time

    p0 = eis_get_daily_data(files, 'MHC_QCM_MSW',       1, 9, mxp0, mnp0, base_time, end_time)
    p1 = eis_get_daily_data(files, 'MHC_QCM_LSW',       2, 9, mx1, mn1)
    p2 = eis_get_daily_data(files, 'MHC_QCM1_TEMP',     3, 9, mx1, mn1)
    p3 = eis_get_daily_data(files, 'MHC_QCM2_TEMP',     4, 9, mx1, mn1)
    p4 = eis_get_daily_data(files, 'MHC_QCM_INT_CLOCK', 5, 9, mx1, mn1)

    x = lindgen(n_elements(p0))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_qcm_status.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC QCM MSW',ytitle='Raw',charsize=cs  

    utplot,x,p1,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC QCM LSW',ytitle='Raw',charsize=cs  

    utplot,x,p2,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC QCM1 TEMP',ytitle='Raw',charsize=cs  

    utplot,x,p3,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC QCM2 TEMP',ytitle='Raw',charsize=cs  

    utplot,x,p4,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC QCM INT CLOCK',ytitle='Raw',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_subcomm, files, output, end_time

    pi = eis_get_daily_data(files, 'MHC_PERFORM_INDEX', 1, 10, mxp0, mnp0, base_time, end_time)
    pp = eis_get_daily_data(files, 'MHC_PERFORM_PARM',  2, 10, mx1, mn1)
    nsamp = n_elements(pi)

    p1  = pp[where(pi eq 0)]
    p2  = pp[where(pi eq 1)]
    p3  = pp[where(pi eq 2)]
    p4  = pp[where(pi eq 3)]
    p5  = pp[where(pi eq 4)]
    p6  = pp[where(pi eq 5)]
    p7  = pp[where(pi eq 6)]
    p8  = pp[where(pi eq 7)]
    p11 = pp[where(pi eq 10)]
    p12 = pp[where(pi eq 11)]
    p13 = pp[where(pi eq 12)]
    p18 = pp[where(pi eq 17)]
;    p20 = pp[where(pi eq 19)]

    x = lindgen(n_elements(pi))*10

    cs=1.6
   
    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mhc_subcomm.ps'
    !p.multi=[0,1,3]

    utplot,x,pi,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_PERFORM_INDEX',ytitle='Raw',charsize=cs  

    utplot,x,pp,base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_PERFORM_PARM',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p1,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_ANA_BRD_TEMP',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p2,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_AUX_BRD_TEMP',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p3,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_VOLT_REF',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p4,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='MHC_AUX_BRD_VOLT_REF',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p5,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='CAL_LED1_CURRENT',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p6,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='CAL_LED2_CURRENT',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p7,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='CAL_LED1_VOLTAGE',ytitle='Raw',charsize=cs  

    utplot,x,congrid(p8,nsamp),base_time,timerange=[base_time,end_time], /ynozero, $
      xstyle=2,pstyle=4, $
      title='CAL_LED2_VOLTAGE',ytitle='Raw',charsize=cs  

    device,/close
    set_plot,'X'
    !p.multi=0

end

pro mhc_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME', 1,  11, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  11, maxp2, minp2)

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/icu_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_sts3_conversions, dir, output, end_time
 
    files = findfile(dir + 'eis_sts3_*fits', count=count)
    if count eq 0 then begin
        print, 'eis_status_sts3_conversions : No files'
        return
    endif
     
    mhc_voltages,         files, output, end_time
    mhc_currents,         files, output, end_time
    mhc_gp0_temperatures, files, output, end_time
    mhc_gp2_temperatures, files, output, end_time
    mhc_mechanisms,       files, output, end_time
    mhc_status,           files, output, end_time
    mhc_counters,         files, output, end_time
    mhc_qcm_status,       files, output, end_time
    mhc_subcomm,          files, output, end_time
    mhc_spacecraft,       files, output, end_time
end
