function number_of_studies
  status = eis_open_db(/STUDY)
  n = db_info('entries')
  dbclose
  return, n[0]
end

pro create_def_files

  studies  = './nstudies.txt'
  path     = getenv('HOME') + '/studies/def/'

  i = 0
  openr, lu, studies, /get_lun
  readf, lu, i, format = '(I)'
  close, lu
  free_lun, lu

  n = number_of_studies()

  for id = i + 1, n do begin
     print, 'Dumping study ' + strtrim(string(id))
     study = db_read_study_entry(id)
     study_number = string(id, format = '(I06)')
     if n_tags(study) eq 0 then begin
        print, 'No database entry for study id ' + strtrim(string(id), 2)
     endif else begin
        file_string = 'study_' + strtrim(string(format = '(I06)', id), 2) + '.def.txt'
        print, 'id = ' + file_string
        openw, lu, path + file_string, /get_lun
        str = eis_export_study(study, /saved)
        s = size(str)
        for line = 0, s[1] - 1 do begin
           printf, lu, str[line]
        endfor
        close, lu
        free_lun, lu
     endelse
  endfor

  openw, lu, studies, /get_lun
  printf, lu, strtrim(string(n), 2)
  close, lu
  free_lun, lu

end
