pro min_max, param,  p_min,  p_max,  p_avg,  p_std,  p_skew,  p_kurt
    p_min  = min(param)
    p_max  = max(param)

    mom = moment(param)
    p_avg  = mom[0]
    p_std  = mom[1]
    p_skew = mom[2]
    p_kurt = mom[3]

end

pro eis_cam_pwr_header, lu
    printf, lu, 'start_date,end_date,p5v1_dig_min,p5v1_dig_max,p5v1_dig_avg,p2v5_dig_min,p2v5_dig_max,p2v5_dig_avg,p5v_ana_min,p5v_ana_max,p5v_ana_avg,p5v_anb_min,p5v_anb_max,p5v_anb_avg,n5v_ana_min,n5v_ana_max,n5v_ana_avg,n5v_anb_min,n5v_anb_max,n5v_anb_avg,p36va_min,p26va_max,p36va_avg,p36vb_min,p26vb_max,p36vb_avg,p12va_min,p12va_max,p12va_avg,p12vb_min,p12vb_max,p12vb_avg,n10va_min,n10va_max,n10va_avg,n10vb_min,n10vb_max,n10vb_avg,p2v5i_dig_min,p2v5i_dig_max,p2v5i_dig_avg,p5vi_dig_min,p5vi_dig_max,p5vi_dig_avg,p5vi_ana_min,p5vi_ana_max,p5vi_ana_avg,p5vi_anb_min,p5vi_anb_max,p5vi_anb_avg,n5vi_ana_min,n5vi_ana_max,n5vi_ana_avg,n5vi_anb_min,n5vi_anb_max,n5vi_anb_avg,p36via_min,p26via_max,p36via_avg,p36vib_min,p26vib_max,p36vib_avg,p12via_min,p12via_max,p12via_avg,p12vib_min,p12vib_max,p12vib_avg,p5v1_dig_pwr_min,p5v1_dig_pwr_max,p5v1_dig_pwr_avg,p2v5_dig_pwr_min,p2v5_dig_pwr_max,p2v5_dig_pwr_avg,p5v_ana_pwr_min,p5v_ana_pwr_max,p5v_ana_pwr_avg,p5v_anb_pwr_min,p5v_anb_pwr_max,p5v_anb_pwr_avg,n5v_ana_pwr_min,n5v_ana_pwr_max,n5v_ana_pwr_avg,n5v_anb_pwr_min,n5v_anb_pwr_max,n5v_anb_pwr_avg,p36va_pwr_min,p26va_pwr_max,p36va_pwr_avg,p36vb_pwr_min,p26vb_pwr_max,p36vb_pwr_avg,p12va_pwr_min,p12va_pwr_max,p12va_pwr_avg,p12vb_pwr_min,p12vb_pwr_max,p12vb_pwr_avg'

end

pro eis_cam_pwr_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories in ' + dir
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_cam_pwr_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts2_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string, lu, 34
        endif else begin

            v  = eis_convert_cam_voltage_p5v1dig(eis_get_daily_data(files, 'CAM_P5V1_DIG',  1, 1, maxp0, minp0, stim, etim))
            c  = eis_convert_cam_current_p5vdig (eis_get_daily_data(files, 'CAM_P5VI_DIG',  1, 2, maxp1, minp1))
            pwr = abs(v * c)
            min_max, v,   v0_min,   v0_max,   v0_avg,   v0_std,   v0_skew,   v0_kurt
            min_max, c,   c0_min,   c0_max,   c0_avg,   c0_std,   c0_skew,   c0_kurt
            min_max, pwr, pwr0_min, pwr0_max, pwr0_avg, pwr0_std, pwr0_skew, pwr0_kurt

            v  = eis_convert_cam_voltage_p2v5dig (eis_get_daily_data(files, 'CAM_P2V5_DIG',  2, 1, maxp0, minp0))
            c  = eis_convert_cam_current_p2p5vdig(eis_get_daily_data(files, 'CAM_P2V5I_DIG', 2, 2, maxp1, minp1))
            pwr = abs(v * c)
            min_max, v,   v1_min,   v1_max,   v1_avg,   v1_std,   v1_skew,   v1_kurt
            min_max, c,   c1_min,   c1_max,   c1_avg,   c1_std,   c1_skew,   c1_kurt
            min_max, pwr, pwr1_min, pwr1_max, pwr1_avg, pwr1_std, pwr1_skew, pwr1_kurt
            
            v = eis_convert_cam_voltage_p5vana(eis_get_daily_data(files,'CAM_P5V_AN_A',  3, 1, maxp3, minp3))
            c = eis_convert_cam_current_p5vana(eis_get_daily_data(files,'CAM_P5VI_AN_A', 3, 2, maxp3, minp3))
            pwr = abs(v * c)
            min_max, v,   v2_min,   v2_max,   v2_avg,   v2_std,   v2_skew,   v2_kurt
            min_max, c,   c2_min,   c2_max,   c2_avg,   c2_std,   c2_skew,   c2_kurt
            min_max, pwr, pwr2_min, pwr2_max, pwr2_avg, pwr2_std, pwr2_skew, pwr2_kurt

            v = eis_convert_cam_voltage_p5vanb(eis_get_daily_data(files,'CAM_P5V_AN_B',  4, 1, maxp4, minp4))
            c = eis_convert_cam_current_p5vanb(eis_get_daily_data(files,'CAM_P5VI_AN_B', 4, 2, maxp4, minp4))
            pwr = abs(v * c)
            min_max, v,   v3_min,   v3_max,   v3_avg,   v3_std,   v3_skew,   v3_kurt
            min_max, c,   c3_min,   c3_max,   c3_avg,   c3_std,   c3_skew,   c3_kurt
            min_max, pwr, pwr3_min, pwr3_max, pwr3_avg, pwr3_std, pwr3_skew, pwr3_kurt

            v = eis_convert_cam_voltage_n5vana(eis_get_daily_data(files,'CAM_N5V_AN_A',  5, 1, maxp5, minp5))
            c = eis_convert_cam_current_n5vana(eis_get_daily_data(files,'CAM_N5VI_AN_A', 5, 2, maxp5, minp5))
            pwr = abs(v * c)
            min_max, v,   v4_min,   v4_max,   v4_avg,   v4_std,   v4_skew,   v4_kurt
            min_max, c,   c4_min,   c4_max,   c4_avg,   c4_std,   c4_skew,   c4_kurt
            min_max, pwr, pwr4_min, pwr4_max, pwr4_avg, pwr4_std, pwr4_skew, pwr4_kurt

            v = eis_convert_cam_voltage_n5vanb(eis_get_daily_data(files,'CAM_N5V_AN_B',  6, 1, maxp5, minp5))
            c = eis_convert_cam_current_n5vanb(eis_get_daily_data(files,'CAM_N5VI_AN_B', 6, 2, maxp5, minp5))
            pwr = abs(v * c)
            min_max, v,   v5_min,   v5_max,   v5_avg,   v5_std,   v5_skew,   v5_kurt
            min_max, c,   c5_min,   c5_max,   c5_avg,   c5_std,   c5_skew,   c5_kurt
            min_max, pwr, pwr5_min, pwr5_max, pwr5_avg, pwr5_std, pwr5_skew, pwr5_kurt

            v = eis_convert_cam_voltage_p36va (eis_get_daily_data(files,'CAM_P36V_A',    7, 1, maxp5, minp5))
            c = eis_convert_cam_current_p36va (eis_get_daily_data(files,'CAM_P36VI_A',   7, 2, maxp5, minp5))
            pwr = abs(v * c)
            min_max, v,   v6_min,   v6_max,   v6_avg,   v6_std,   v6_skew,   v6_kurt
            min_max, c,   c6_min,   c6_max,   c6_avg,   c6_std,   c6_skew,   c6_kurt
            min_max, pwr, pwr6_min, pwr6_max, pwr6_avg, pwr6_std, pwr6_skew, pwr6_kurt

            v = eis_convert_cam_voltage_p36vb (eis_get_daily_data(files,'CAM_P36V_B',    8, 1, maxp5, minp5))
            c = eis_convert_cam_current_p36vb (eis_get_daily_data(files,'CAM_P36VI_B',   8, 2, maxp5, minp5))
            pwr = abs(v * c)
            min_max, v,   v7_min,   v7_max,   v7_avg,   v7_std,   v7_skew,   v7_kurt
            min_max, c,   c7_min,   c7_max,   c7_avg,   c7_std,   c7_skew,   c7_kurt
            min_max, pwr, pwr7_min, pwr7_max, pwr7_avg, pwr7_std, pwr7_skew, pwr7_kurt

            v = eis_convert_cam_voltage_p12va (eis_get_daily_data(files,'CAM_P12V_A',    9, 1, maxp5, minp5))
            c = eis_convert_cam_current_p12va (eis_get_daily_data(files,'CAM_P12VI_A',   9, 2, maxp5, minp5))
            pwr = abs(v * c)
            min_max, v,   v8_min,   v8_max,   v8_avg,   v8_std,   v8_skew,   v8_kurt
            min_max, c,   c8_min,   c8_max,   c8_avg,   c8_std,   c8_skew,   c8_kurt
            min_max, pwr, pwr8_min, pwr8_max, pwr8_avg, pwr8_std, pwr8_skew, pwr8_kurt

            v = eis_convert_cam_voltage_p12vb (eis_get_daily_data(files,'CAM_P12V_B',   10, 1, maxp5, minp5))
            c = eis_convert_cam_current_p12vb (eis_get_daily_data(files,'CAM_P12VI_B',  10, 2, maxp5, minp5))
            pwr = abs(v * c)
            min_max, v,   v9_min,   v9_max,   v9_avg,   v9_std,   v9_skew,   v9_kurt
            min_max, c,   c9_min,   c9_max,   c9_avg,   c9_std,   c9_skew,   c9_kurt
            min_max, pwr, pwr9_min, pwr9_max, pwr9_avg, pwr9_std, pwr9_skew, pwr9_kurt

            v = eis_convert_cam_voltage_n10va (eis_get_daily_data(files,'CAM_N10V_A',   11, 1, maxp5, minp5))
            min_max, v,   v10_min,   v10_max,   v10_avg,   v10_std,   v10_skew,   v10_kurt

            v = eis_convert_cam_voltage_n10vb (eis_get_daily_data(files,'CAM_N10V_B',   12, 1, maxp5, minp5))
            min_max, v,   v11_min,   v11_max,   v11_avg,   v11_std,   v11_skew,   v11_kurt

            print,format='(2(A23," "),95(F8.2,","),F8.2)', $
              stim,etim,$
              v0_min,v0_max,v0_avg,v1_min,v1_max,v1_avg,v2_min,v2_max,v2_avg,v3_min,v3_max,v3_avg,v4_min,v4_max,v4_avg,$
              v5_min,v5_max,v5_avg,v6_min,v6_max,v6_avg,v7_min,v7_max,v7_avg,v8_min,v8_max,v8_avg,v9_min,v9_max,v9_avg,$
              v10_min,v10_max,v10_avg,v11_min,v11_max,v11_avg,$
              c0_min,c0_max,c0_avg,c1_min,c1_max,c1_avg,c2_min,c2_max,c2_avg,c3_min,c3_max,c3_avg,c4_min,c4_max,c4_avg,$
              c5_min,c5_max,c5_avg,c6_min,c6_max,c6_avg,c7_min,c7_max,c7_avg,c8_min,c8_max,c8_avg,c9_min,c9_max,c9_avg,$
              pwr0_min,pwr0_max,pwr0_avg,pwr1_min,pwr1_max,pwr1_avg,pwr2_min,pwr2_max,pwr2_avg,pwr3_min,pwr3_max,pwr3_avg,$
              pwr4_min,pwr4_max,pwr4_avg,pwr5_min,pwr5_max,pwr5_avg,pwr6_min,pwr6_max,pwr6_avg,pwr7_min,pwr7_max,pwr7_avg,$
              pwr8_min,pwr8_max,pwr8_avg,pwr9_min,pwr9_max,pwr9_avg

             if using_log then begin
                printf,lu,format='(2(A23,","),95(F8.2,","),F8.2)', $
                  stim,etim,$
                  v0_min,v0_max,v0_avg,v1_min,v1_max,v1_avg,v2_min,v2_max,v2_avg,v3_min,v3_max,v3_avg,v4_min,v4_max,v4_avg,$
                  v5_min,v5_max,v5_avg,v6_min,v6_max,v6_avg,v7_min,v7_max,v7_avg,v8_min,v8_max,v8_avg,v9_min,v9_max,v9_avg,$
                  v10_min,v10_max,v10_avg,v11_min,v11_max,v11_avg,$
                  c0_min,c0_max,c0_avg,c1_min,c1_max,c1_avg,c2_min,c2_max,c2_avg,c3_min,c3_max,c3_avg,c4_min,c4_max,c4_avg,$
                  c5_min,c5_max,c5_avg,c6_min,c6_max,c6_avg,c7_min,c7_max,c7_avg,c8_min,c8_max,c8_avg,c9_min,c9_max,c9_avg,$
                  pwr0_min,pwr0_max,pwr0_avg,pwr1_min,pwr1_max,pwr1_avg,pwr2_min,pwr2_max,pwr2_avg,pwr3_min,pwr3_max,pwr3_avg,$
                  pwr4_min,pwr4_max,pwr4_avg,pwr5_min,pwr5_max,pwr5_avg,pwr6_min,pwr6_max,pwr6_avg,pwr7_min,pwr7_max,pwr7_avg,$
                  pwr8_min,pwr8_max,pwr8_avg,pwr9_min,pwr9_max,pwr9_avg
            endif
        endelse
skip:
    endfor
    if using_log then begin
        close, lu
        free_lun, lu
    endif
end

