pro eis_mbus_pwr_header, lu
    printf, lu, 'start_date,end_date,28v_min,28v_max,28v_avg,28vi_min,28vi_max,28vi_avg,28v_pwr_min,28v_pwr_max,28v_pwr_avg'
end

pro eis_mbus_pwr_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories in ' + dir
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_mbus_pwr_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts1_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string, lu, 5
        endif else begin

            p1 = reform(eis_get_daily_data(files, 'MBUS_28V', 5, 1, maxp5, minp5,stim, etim))
            p2 = reform(eis_get_daily_data(files,'MBUS_28I', 5, 2, maxp4, minp4))

            m28v_min = eis_convert_icu_voltage_mbus28v([minp5])
            m28v_max = eis_convert_icu_voltage_mbus28v([maxp5])
            m28i_min = eis_convert_icu_current_mbus28v([minp4])
            m28i_max = eis_convert_icu_current_mbus28v([maxp4])

            m28pwr_min = m28v_min * m28i_min
            m28pwr_max = m28v_max * m28i_max

            mom = moment(p1)
            m28v_avg = eis_convert_icu_voltage_mbus28v([mom[0]])
            m28v_std = sqrt(mom[1])
            m28v_skew = mom[2]
            m28v_kurt = mom[3]
            mom = moment(p2)
            m28i_avg = eis_convert_icu_current_mbus28v([mom[0]])
            m28i_std = sqrt(mom[1])
            m28i_skew = mom[2]
            m28i_kurt = mom[3]

            mom = moment(eis_convert_icu_voltage_mbus28v(p1) * eis_convert_icu_current_mbus28v(p2))
            m28pwr_avg = mom[0]
            m28pwr_std = sqrt(mom[1])
            m28pwr_skew = mom[2]
            m28pwr_kurt = mom[3]

            print,format='(2(A23," "),3(F6.2),3(F6.3),3(F6.2))', $
              stim,etim,m28v_min,m28v_max,m28v_avg,m28i_min,m28i_max,m28i_avg,m28pwr_min,m28pwr_max,m28pwr_avg

             if using_log then begin
;                printf,lu,format='(2(A23,","),3(F8.2,","),3(F8.3,","),2(F8.2,","),F8.2)', $
                printf,lu,format='(2(A23,","),3(F8.2,","),3(F8.3,","),3(F8.2,","),3(F8.2,","),3(F8.2,","),2(F8.2,","),F8.2)', $
                  stim, etim, $
                  m28v_min,   m28v_max,   m28v_avg,   $
                  m28i_min,   m28i_max,   m28i_avg,   $
                  m28pwr_min, m28pwr_max, m28pwr_avg, $
                  m28v_std,   m28v_skew,  m28v_kurt,  $
                  m28i_std,   m28i_skew,  m28i_kurt,  $
                  m28pwr_std,   m28pwr_skew,  m28pwr_kurt
            endif
        endelse
skip:
    endfor
    if using_log then begin
        close, lu
        free_lun, lu
    endif
end

