; filename		(string)	['$HOME/work/localdata/log/status/trends/eis_ccd_temp_trend_200704.txt']
; xtit (plot title)	(string)	['April 2007']
; output		(string)	['$HOME/work/localdata/log/status/trends/ccd_temp_200704']
pro eis_plot_cam_temp_trend, filename, xtit, output=output

    ; Restore 'template'
    restore, '$HOME/work/idl/templates/cam_temp_template.sav'
    data = read_ascii(filename, template=template)

    ytit='Degrees C'

    cs=1.6

    nel = n_elements(data.start_date)
    x   = bindgen(nel)
    x = x + 1

    minl = min(data.lower_min)
    minu = min(data.upper_min)
    maxl = max(data.lower_max)
    maxu = max(data.upper_max)

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output + '_cam.ps'
    !p.multi=[0,1,3]

    plot,  x, data.upper_min, xrange=[1, nel], yrange=[minu,maxu], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='Camera Upper', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.upper_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.upper_max, psym=10
    oplot, x, data.upper_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.upper_avg, psym=10
    oplot, x, data.upper_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.lower_min, xrange=[1, nel], yrange=[minl,maxl], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='Camera Lower', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.lower_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.lower_max, psym=10
    oplot, x, data.lower_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.lower_avg, psym=10
    oplot, x, data.lower_avg, psym=7, min_value=-65534., max_value=65535.

    device,/close
    set_plot,'X'
    !p.multi=0

end
