pro eis_plot_icu_psu_pwr_trend, filename, ptit, output=output
    openr, lu, filename, /get_lun
    line = ''
    ; Read header line
    readf, lu, line
 
    readf, lu, line
    parts = str_sep(line, ',')
    start_times = [parts[0]]
    end_times   = [parts[1]]
    p2v5_min   = [parts[2]]
    p2v5_max   = [parts[3]]
    p2v5_avg   = [parts[4]]
    p5v_min   = [parts[5]]
    p5v_max   = [parts[6]]
    p5v_avg   = [parts[7]]
    p15v_min   = [parts[8]]
    p15v_max   = [parts[9]]
    p15v_avg   = [parts[10]]
    n15v_min = [parts[11]]
    n15v_max = [parts[12]]
    n15v_avg = [parts[13]]

    p2v5i_min = [parts[14]]
    p2v5i_max = [parts[15]]
    p2v5i_avg = [parts[16]]
    p5vi_min  = [parts[17]]
    p5vi_max  = [parts[18]]
    p5vi_avg  = [parts[19]]
    p15vi_min = [parts[20]]
    p15vi_max = [parts[21]]
    p15vi_avg = [parts[22]]
    n15vi_min = [parts[23]]
    n15vi_max = [parts[24]]
    n15vi_avg = [parts[25]]

    p2v5v_pwr_min = [parts[26]]
    p2v5v_pwr_max = [parts[27]]
    p2v5v_pwr_avg = [parts[28]]
    p5v_pwr_min   = [parts[29]]
    p5v_pwr_max   = [parts[30]]
    p5v_pwr_avg   = [parts[31]]
    p15v_pwr_min  = [parts[32]]
    p15v_pwr_max  = [parts[33]]
    p15v_pwr_avg  = [parts[34]]
    n15v_pwr_min  = [parts[35]]
    n15v_pwr_max  = [parts[36]]
    n15v_pwr_avg  = [parts[37]]

    while not eof(lu) do begin
        readf, lu, line
        parts = str_sep(line, ',')
        start_times = [start_times, parts[0]]
        end_times   = [end_times, parts[1]]

        p2v5_min   = [p2v5_min,parts[2]]
        p2v5_max   = [p2v5_max,parts[3]]
        p2v5_avg   = [p2v5_avg,parts[4]]
        p5v_min   = [p5v_min,parts[5]]
        p5v_max   = [p5v_max,parts[6]]
        p5v_avg   = [p5v_avg,parts[7]]
        p15v_min   = [p15v_min,parts[8]]
        p15v_max   = [p15v_max,parts[9]]
        p15v_avg   = [p15v_avg,parts[10]]
        n15v_min = [n15v_min,parts[11]]
        n15v_max = [n15v_max,parts[12]]
        n15v_avg = [n15v_avg,parts[13]]
        
        p2v5i_min = [p2v5i_min,parts[14]]
        p2v5i_max = [p2v5i_max,parts[15]]
        p2v5i_avg = [p2v5i_avg,parts[16]]
        p5vi_min  = [p5vi_min,parts[17]]
        p5vi_max  = [p5vi_max,parts[18]]
        p5vi_avg  = [p5vi_avg,parts[19]]
        p15vi_min = [p15vi_min,parts[20]]
        p15vi_max = [p15vi_max,parts[21]]
        p15vi_avg = [p15vi_avg,parts[22]]
        n15vi_min = [n15vi_min,parts[23]]
        n15vi_max = [n15vi_max,parts[24]]
        n15vi_avg = [n15vi_avg,parts[25]]
        
        p2v5v_pwr_min = [p2v5v_pwr_min,parts[26]]
        p2v5v_pwr_max = [p2v5v_pwr_max,parts[27]]
        p2v5v_pwr_avg = [p2v5v_pwr_avg,parts[28]]
        p5v_pwr_min   = [p5v_pwr_min,parts[29]]
        p5v_pwr_max   = [p5v_pwr_max,parts[30]]
        p5v_pwr_avg   = [p5v_pwr_avg,parts[31]]
        p15v_pwr_min  = [p15v_pwr_min,parts[32]]
        p15v_pwr_max  = [p15v_pwr_max,parts[33]]
        p15v_pwr_avg  = [p15v_pwr_avg,parts[34]]
        n15v_pwr_min  = [n15v_pwr_min,parts[35]]
        n15v_pwr_max  = [n15v_pwr_max,parts[36]]
        n15v_pwr_avg  = [n15v_pwr_avg,parts[37]]

    endwhile
    close, lu
    free_lun, lu
    eis_plot_trend_data, '+2.5 VOLTS',        ptit, output+'_p2v5',    start_times, end_times, p2v5_min,     p2v5_max,       p2v5_avg,      'Voltage'
    eis_plot_trend_data, '+5 VOLTS',          ptit, output+'_p5v',     start_times, end_times, p5v_min,       p5v_max,       p5v_avg,       'Voltage'
    eis_plot_trend_data, '+15 VOLTS',         ptit, output+'_p15v',    start_times, end_times, p15v_min,      p15v_max,      p15v_avg,      'Voltage'
    eis_plot_trend_data, '-15 VOLTS',         ptit, output+'_n15v',    start_times, end_times, n15v_min,      n15v_max,      n15v_avg,      'Voltage'

    eis_plot_trend_data, '+2.5 VOLT CURRENT', ptit, output+'_p2v5i',   start_times, end_times, p2v5i_min,     p2v5i_max,     p2v5i_avg,     'Amps'
    eis_plot_trend_data, '+5 VOLT CURRENT',   ptit, output+'_p5vi',    start_times, end_times, p5vi_min,      p5vi_max,      p5vi_avg,      'Amps'
    eis_plot_trend_data, '+15 VOLT CURRENT',  ptit, output+'_p15vi',   start_times, end_times, p15vi_min,     p15vi_max,     p15vi_avg,     'Amps'
    eis_plot_trend_data, '-15 VOLT CURRENT',  ptit, output+'_n15vi',   start_times, end_times, n15vi_min,     n15vi_max,     n15vi_avg,     'Amps'

    eis_plot_trend_data, '+2.5 VOLT POWER',   ptit, output+'_p2v5pwr', start_times, end_times, p2v5v_pwr_min, p2v5v_pwr_max, p2v5v_pwr_avg, 'Watts'
    eis_plot_trend_data, '+5 VOLT POWER',     ptit, output+'_p5vpwr',  start_times, end_times, p5v_pwr_min,   p5v_pwr_max,   p5v_pwr_avg,   'Watts'
    eis_plot_trend_data, '+15 VOLT POWER',    ptit, output+'_p15vpwr', start_times, end_times, p15v_pwr_min,  p15v_pwr_max,  p15v_pwr_avg,  'Watts'
    eis_plot_trend_data, '-15 VOLT POWER',    ptit, output+'_n15vpwr', start_times, end_times, n15v_pwr_min,  n15v_pwr_max,  n15v_pwr_avg,  'Watts'
end
