pro eis_plot_mbus_pwr_trend, filename, ptit, output=output
    openr, lu, filename, /get_lun
    line = ''
    ; Read header line
    readf, lu, line
 
    readf, lu, line
    parts = str_sep(line, ',')
    start_times = [parts[0]]
    end_times   = [parts[1]]
    v_mins   = [parts[2]]
    v_maxs   = [parts[3]]
    v_avgs   = [parts[4]]
    i_mins   = [parts[5]]
    i_maxs   = [parts[6]]
    i_avgs   = [parts[7]]
    p_mins   = [parts[8]]
    p_maxs   = [parts[9]]
    p_avgs   = [parts[10]]

    v_std    = [parts[11]]
    v_skew   = [parts[12]]
    v_kurt   = [parts[13]]
    i_std    = [parts[14]]
    i_skew   = [parts[15]]
    i_kurt   = [parts[16]]
    p_std    = [parts[17]]
    p_skew   = [parts[18]]
    p_kurt   = [parts[19]]
    
    while not eof(lu) do begin
        readf, lu, line
        parts = str_sep(line, ',')
        start_times = [start_times, parts[0]]
        end_times   = [end_times, parts[1]]
        v_mins   = [v_mins, parts[2]]
        v_maxs   = [v_maxs, parts[3]]
        v_avgs   = [v_avgs, parts[4]]
        i_mins   = [i_mins, parts[5]]
        i_maxs   = [i_maxs, parts[6]]
        i_avgs   = [i_avgs, parts[7]]
        p_mins   = [p_mins, parts[8]]
        p_maxs   = [p_maxs, parts[9]]
        p_avgs   = [p_avgs, parts[10]]

        v_std    = [v_std,  parts[11]]
        v_skew   = [v_skew, parts[12]]
        v_kurt   = [v_kurt, parts[13]]
        i_std    = [i_std,  parts[14]]
        i_skew   = [i_skew, parts[15]]
        i_kurt   = [i_kurt, parts[16]]
        p_std    = [p_std,  parts[17]]
        p_skew   = [p_skew, parts[18]]
        p_kurt   = [p_kurt, parts[19]]

    endwhile
    close, lu
    free_lun, lu
    eis_plot_trend_data, 'MBUS_VOLTAGE', ptit, output+'_28v', start_times, end_times, v_mins, v_maxs, v_avgs, 'Voltage'
    eis_plot_trend_data, 'MBUS_CURRENT', ptit, output+'_28vi', start_times, end_times, i_mins, i_maxs, i_avgs, 'Amps'
    eis_plot_trend_data, 'MBUS_POWER',   ptit, output+'_28vpwr', start_times, end_times, p_mins, p_maxs, p_avgs, 'Watts'
    eis_plot_trend_data, 'MBUS_VOLTAGE_STD', ptit, output+'_28v_std', start_times, end_times, v_std, v_skew, v_kurt, '', /std
    eis_plot_trend_data, 'MBUS_CURRENT_STD', ptit, output+'_28i_std', start_times, end_times, i_std, i_skew, i_kurt, '', /std
    eis_plot_trend_data, 'MBUS_POWER_STD',   ptit, output+'_28vi_std', start_times, end_times, p_std, p_skew, p_kurt, '', /std
end
