; filename		(string)	['$HOME/work/localdata/log/status/trends/eis_ccd_temp_trend_200704.txt']
; xtit (plot title)	(string)	['April 2007']
; output		(string)	['$HOME/work/localdata/log/status/trends/ccd_temp_200704']
pro eis_plot_str_temp_trend, filename, xtit, output=output

    ; Restore 'template'
    restore, '$HOME/work/idl/templates/eis_str_temp_template.sav'
    data = read_ascii(filename, template=template)

    ytit='Degrees C'

    cs=1.6

    nel = n_elements(data.start_date)
    x   = bindgen(nel)
    x = x + 1

    htra_min = min(data.htra_min)
    htra_max = max(data.htra_max)

    str4_min = min(data.str4_min)
    str4_max = max(data.str4_max)

    str5_min = min(data.str5_min)
    str5_max = max(data.str5_max)

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output + '_str.ps'
    !p.multi=[0,1,3]

    plot,  x, data.htra_min, xrange=[1, nel], yrange=[htra_min,htra_max], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='HTR A', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.htra_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.htra_max, psym=10
    oplot, x, data.htra_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.htra_avg, psym=10
    oplot, x, data.htra_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.htrb_min, xrange=[1, nel], yrange=[min(data.htrb_min),max(data.htrb_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='HTR B', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.htrb_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.htrb_max, psym=10
    oplot, x, data.htrb_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.htrb_avg, psym=10
    oplot, x, data.htrb_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.htrc_min, xrange=[1, nel], yrange=[min(data.htrc_min),max(data.htrc_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='HTR C', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.htrc_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.htrc_max, psym=10
    oplot, x, data.htrc_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.htrc_avg, psym=10
    oplot, x, data.htrc_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.icu1_min, xrange=[1, nel], yrange=[min(data.icu1_min),max(data.icu1_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='ICU 1', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.icu1_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.icu1_max, psym=10
    oplot, x, data.icu1_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.icu1_avg, psym=10
    oplot, x, data.icu1_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.icu2_min, xrange=[1, nel], yrange=[min(data.icu2_min),max(data.icu2_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='ICU 2', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.icu2_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.icu2_max, psym=10
    oplot, x, data.icu2_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.icu2_avg, psym=10
    oplot, x, data.icu2_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str1_min, xrange=[1, nel], yrange=[min(data.str1_min),max(data.str1_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 1', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str1_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str1_max, psym=10
    oplot, x, data.str1_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str1_avg, psym=10
    oplot, x, data.str1_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str2_min, xrange=[1, nel], yrange=[min(data.str2_min),max(data.str2_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 2', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str2_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str2_max, psym=10
    oplot, x, data.str2_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str2_avg, psym=10
    oplot, x, data.str2_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str3_min, xrange=[1, nel], yrange=[min(data.str3_min),max(data.str3_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 3', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str3_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str3_max, psym=10
    oplot, x, data.str3_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str3_avg, psym=10
    oplot, x, data.str3_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str4_min, xrange=[1, nel], yrange=[str4_min,str4_max], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 4', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str4_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str4_max, psym=10
    oplot, x, data.str4_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str4_avg, psym=10
    oplot, x, data.str4_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str5_min, xrange=[1, nel], yrange=[str5_min,str5_max], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 5', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str5_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str5_max, psym=10
    oplot, x, data.str5_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str5_avg, psym=10
    oplot, x, data.str5_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str6_min, xrange=[1, nel], yrange=[min(data.str6_min),max(data.str6_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 6', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str6_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str6_max, psym=10
    oplot, x, data.str6_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str6_avg, psym=10
    oplot, x, data.str6_avg, psym=7, min_value=-65534., max_value=65535.

    plot,  x, data.str7_min, xrange=[1, nel], yrange=[min(data.str7_min),max(data.str7_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='STR 7', xtitle=xtit, ytitle=ytit, charsize=cs
    oplot, x, data.str7_min, psym=2, min_value=-65534., max_value=65535.
    oplot, x, data.str7_max, psym=10
    oplot, x, data.str7_max, psym=4, min_value=-65534., max_value=65535.
    oplot, x, data.str7_avg, psym=10
    oplot, x, data.str7_avg, psym=7, min_value=-65534., max_value=65535.

    device,/close
    set_plot,'X'
    !p.multi=0


;    eis_plot_trend_data, 'HTR_A', ptit, output+'_htra', start_times, end_times, htra_mins, htra_maxs, htra_avgs, 'Degrees C'
;    eis_plot_trend_data, 'HTR_B', ptit, output+'_htrb', start_times, end_times, htrb_mins, htrb_maxs, htrb_avgs, 'Degrees C'
;    eis_plot_trend_data, 'HTR_C', ptit, output+'_htrc', start_times, end_times, htrc_mins, htrc_maxs, htrc_avgs, 'Degrees C'
;    eis_plot_trend_data, 'ICU_1', ptit, output+'_icu1', start_times, end_times, icu1_mins, icu1_maxs, icu1_avgs, 'Degrees C'
;    eis_plot_trend_data, 'ICU_2', ptit, output+'_icu2', start_times, end_times, icu2_mins, icu2_maxs, icu2_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_1', ptit, output+'_str1', start_times, end_times, str1_mins, str1_maxs, str1_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_2', ptit, output+'_str2', start_times, end_times, str2_mins, str2_maxs, str2_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_3', ptit, output+'_str3', start_times, end_times, str3_mins, str3_maxs, str3_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_4', ptit, output+'_str4', start_times, end_times, str4_mins, str4_maxs, str4_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_5', ptit, output+'_str5', start_times, end_times, str5_mins, str5_maxs, str5_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_6', ptit, output+'_str6', start_times, end_times, str6_mins, str6_maxs, str6_avgs, 'Degrees C'
;    eis_plot_trend_data, 'STR_7', ptit, output+'_str7', start_times, end_times, str7_mins, str7_maxs, str7_avgs, 'Degrees C'
                                                                                                  
end
