;+
; NAME:
;       EIS_FITS_CALIB
;
; PURPOSE:
;	Adds keywords related Calibration and data reduction
;	to the primary header of the EIS FITS file.
;
;
; CATEGORY:
;       EIS Data Processing Software.
;
; CALLING SEQUENCE:
;       eis_fits_calib, header, md_hdr
;
; INPUTS:
;       header: The primary header which will have keywords added to it.
;	md_hdr: EIS Mission Data header object array
;       calstat: Calibration status structure
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;       The extended primary header
;
; CALLS:
;	fxhread
;	fxaddpar
;
; COMMON BLOCKS:
;
;
; PROCEDURE:
;
; RESTRICTIONS:
;
;
; MODIFICATION HISTORY:
;       November 2002: ivind Wikstl.
;       23-nov-2005: ivind Wikstl - Added calibration status: calstat
;        2-Feb-2008: Mike Marsh     - Added photon calibration status
;        6-Feb-2008: A. Gardini     - Modified calstat.
;       20-Feb-2008: A. Gardini     - Error corrected in calstat.
;       20-May-2008: A. Gardini     - Added retain calibration status
;-
pro eis_fits_calib, header, md_hdr, data, plan, rescued=rescued
;
  if n_elements(rescued) eq 0 then rescued=0
; get calibration status structure

  calstat = data-> getcalstat()

; hlz and saa (now from spcd, should be readfrom ISACS plan
  saa = plan-> getsaa()
  hlz = plan-> gethlz()
; determine FITS level. If all calibrations have been performed, then it is 1,
; else it is 0:

;  datalev = 1
;  for i=0, n_tags(calstat) - 1 do if calstat.(i) = 0 then datalev = 0

;  fitslev = 'LEVEL '+strtrim(string(datalev),2)

  exp_info = md_hdr[0]-> getexp_info()
; CCD read out nodes (True or False)
  ron = exp_info.ron_ccdar
  if ron gt 0 then ccdar = 'T' else ccdar = 'F'
  ron = exp_info.ron_ccdal
  if ron gt 0 then ccdal = 'T' else ccdal = 'F'
  ron = exp_info.ron_ccdbr
  if ron gt 0 then ccdbr = 'T' else ccdbr = 'F'
  ron = exp_info.ron_ccdbl
  if ron gt 0 then ccdbl = 'T' else ccdbl = 'F'
; science operations control parameters taken from last hdr:
  i=n_elements(md_hdr)-1
  repeat begin
    obt_end = ulong((md_hdr[i]-> getexp_info()).ti_2)
    exp_infol=md_hdr[i]-> getexp_info()
    i=i-1
  endrep until obt_end ne 0

  sciops = exp_infol.xrt_fltr_st
  if sciops gt 0 then xrtfltr = 'T' else xrtfltr = 'F'
  sciops = exp_infol.eis_aec_st
  if sciops gt 0 then eisaec = 'T' else eisaec = 'F'
  sciops = exp_infol.eis_evtr_st
  if sciops gt 0 then eisevtr = 'T' else eisevtr = 'F'
  sciops = exp_infol.eis_fltr_st
  if sciops gt 0 then eisfltr = 'T' else eisfltr = 'F'

  fxaddpar, header, 'cal_dc', calstat.dc, 'Calibration status (Dark Current). 0 = not done, 1 = done'
; fxaddpar, header, 'cal_ff', calstat.ff, 'Calibration status (Flat Field). 0 = not done, 1 = done'
  fxaddpar, header, 'cal_hp', calstat.hp, 'Calibration status (Hot pixels). 0 = not done, 1 = done'
  fxaddpar, header, 'cal_dp', calstat.dp, 'Calibration status (Dusty pixels). 0 = not done, 1 = done'
  fxaddpar, header, 'cal_cr', calstat.cr, 'Calibration status (Cosmic rays). 0 = not done, 1 = done'
; fxaddpar, header, 'cal_wvl', calstat.wvl, 'Calibration status (Wavelength). 0 = not done, 1 = done'
  fxaddpar, header, 'cal_abs', calstat.abs, 'Calibration status (Photometric). 0 = not done, 1 = done'
  fxaddpar, header, 'cal_phot', calstat.phot, 'Calibration status (Photons). 0 = not done, 1 = done'	
  fxaddpar, header, 'cal_reta', calstat.retain, 'Calibration status (Retain pixels less than 0). 0 = not done, 1 = done'	

  fxaddpar, header, 'bitc_ver', fix(md_hdr[0]-> getbit_compr_mode()), $
                    'Bit compression mode'
  fxaddpar, header, 'compmod', fix(md_hdr[0]-> getimg_compr_mode()), $
                    'Image compression mode'
  fxaddpar, header, 'achf_ver', fix(md_hdr[0]-> gethuffman_ac()), $
                    'Huffman AC table'
  fxaddpar, header, 'dchf_ver', fix(md_hdr[0]-> gethuffman_dc()), $
                    'Huffman DC table'
  fxaddpar, header, 'qtab_ver', fix(md_hdr[0]-> getquant_tab()), $
                    'Quantization table'
  fxaddpar, header, 'saa', saa, 'Indicates if satellite is in SAA or not'
  fxaddpar, header, 'hlz', hlz, 'Indicates if satellite is in HLZ or not'
;  fxaddpar, header, 'ccdside', fix(exp_info.ccd_sides), $
;                    'CCD Read-out side'
  fxaddpar, header, 'xocb', fix(exp_info.x_ocb), $
                    'On chip binning x-dir'
  fxaddpar, header, 'yocb', fix(exp_info.y_ocb), $
                    'On chip binning y-dir'
  fxaddpar, header, 'ronccdar', ccdar, $
                    'CCD-A Right read out node selected'
  fxaddpar, header, 'ronccdal', ccdal, $
                    'CCD-A Left read out node selected'
  fxaddpar, header, 'ronccdbr', ccdbr, $
                    'CCD-B Right read out node selected'
  fxaddpar, header, 'ronccdbl', ccdbl, $
                    'CCD-B Left read out node selected'
  fxaddpar, header, 'xrtfltr', xrtfltr, $
                    'XRT Flare Trigger Status (T enabled, F disabled)'
  fxaddpar, header, 'eisaec', eisaec, $
                    'EIS AEC Status (T enabled, F disabled)'
  fxaddpar, header, 'eisevtr', eisevtr, $
                    'EIS Event Trigger Status (T enabled, F disabled)'
  fxaddpar, header, 'eisfltr', eisfltr, $
                    'EIS Flare Trigger Status (T enabled, F disabled)'

  nrppexp = md_hdr[0]->getnr_of_packets() ; number of packets pr. exposure
  nexp = exp_info.nexp                    ; number of packets pr. exposure
  corrupt=0
  for i = 0, nexp*nrppexp -1 do begin
    if md_hdr[i]->getcorrupt() then corrupt=1
  endfor
  if rescued then currupt=1
  if corrupt then missing='T' else missing='F'
  fxaddpar, header, 'rescued',missing, $
                    'Missing or corrupted data (T or F)
    
end
